//
//  MCTimeblockProtocol.h
//  MCFoundation
//
//  Created by aj on Sat Sep 08 2001.
//  Copyright (c) 2001 Marketcircle Inc. All rights reserved.
//

#import <Foundation/Foundation.h>

#import "MCPersistentObject.h"

typedef enum _MCTimeblockType {
    MCTimeblockNoType				= 0,
    MCTimeblockAppointmentType		= 1,
    MCTimeblockEventType			= 2,
    MCTimeblockTaskRelated			= 3,
    MCTimeblockOutboundCall			= 4,
    MCTimeblockInboundCall			= 5,
	
	MCTimeblockChat                 = 6,
	MCTimeblockHoliday              = 7,
	MCTimeblockMeeting              = 8,
	MCTimeblockVideo                = 9
} MCTimeblockType;


typedef enum _MCTimeblockChangeType {
    MCTimeblockNoChange				= 0,
    MCTimeblockStartDateChange			= 1,
    MCTimeblockStartTimeChange			= 2,
    MCTimeblockEndDateChange			= 3,
    MCTimeblockEndTimeChange			= 4,
    MCTimeblockDeleted				= 5
} MCTimeblockChangeType;

extern NSString *MCTimeblockWillChangeNotification;
extern NSString *MCTimeblockDidChangeNotification;

// Notification object is Timeblock, userInfo must have MCEditor
extern NSString *MCTimeblockWillDeleteNotification;
extern NSString *MCTimeblockDidDeleteNotification;

@protocol MCTimeblock <MCPersistentObject, NSObject>

// Method names are format in a cross language way (no objc labels unfortunately)
- (void)changeTimeToStartHour:(int)startHour startMinutes:(int)startMinutes endHour:(int)endHour endMinutes:(int)endMinutes;
- (void)changeToStartDate:(NSCalendarDate *)start andEndDate:(NSCalendarDate *)end;
- (void)changeDateToStartYear:(int)startYear startMonth:(int)startMonth startDay:(int)startDay endYear:(int)endYear endMonth:(int)endMonth endDay:(int)endDay;

// Returns the full start date including date, time & timezone
- (NSCalendarDate *)startDate;

// sets the absolute time
- (void)setStartDate:(NSCalendarDate *)aDate;

// changes the date without altering the time and timezone
- (void)changeStartDateToYearMonthDay:(int)aYear :(int)aMonth :(int)aDay;

// changes the time without altering the date and timezone
- (void)changeStartTimeToHourAndMinutes:(int)anHour :(int)aMinute;


// returns the full end date including date, time and timezone
- (NSCalendarDate *)endDate;

// sets the absolute end date (date, time and timezone)
- (void)setEndDate:(NSCalendarDate *)aDate;

// changes the end date without altering the time and timezone
- (void)changeEndDateToYearMonthDay:(int)aYear :(int)aMonth :(int)aDay;

// changes the time without altering the date and timezone
- (void)changeEndTimeToHourAndMinutes:(int)anHour :(int)aMinute;


// returns the start time in the following format 12:45 PM
- (NSString *)startTimeAsString;

// returns the end time in the following format 12:45 PM
- (NSString *)endTimeAsString;

// returns the start and end time in the following format 12:45 - 6:15 PM or 10 AM - 1:20 PM
- (NSString *)startAndEndTimeAsString;


- (void)setSubject:(NSString *)aNote;
- (NSString *)subject;

// returns the full string description of the time block object without the start and end times (subject and other relevant info)
- (NSString *)displayString;

// truncates displayString to the desired length or shorter (if the displayString is  shorter than aLength
- (NSString *)displayStringForLength:(int)aLength;

// Returns the complete description starting with times and subject -- truncates to length
- (NSString *)completeAppointmentDisplayStringForLength:(int)aLength;
- (NSString *)completeEventDisplayStringForLength:(int)aLength;

// Does a 10:00 AM Subject -- useful for month views 
- (NSString *)startTimeAndSubjectForAppointmentToLength:(int)aLength;


//- (int)colorCode;
- (id)color;

// returns the type of time block (event, appointment, taskRelated)
- (MCTimeblockType)typeIntCode;
- (void)setTypeIntCode:(MCTimeblockType)aCode;

- (BOOL)isDurationGreaterThan24hrs;

- (BOOL)isBannerEvent;
- (BOOL)isAppointment;
- (BOOL)isTaskRelated;
- (BOOL)isRecurring;
- (BOOL)isPast;
- (BOOL)isFuture;

- (BOOL)hasTasks;
- (BOOL)hasNotes;
- (BOOL)hasContacts;
- (BOOL)hasFiles;

-(BOOL)containsMonth:(int)aMonth;
-(BOOL)containsYear:(int)aYear;
-(BOOL)containsDay:(int)aDay month:(int)aMonth;

-(BOOL)containsTime:(NSCalendarDate *)slotDate;
-(BOOL)isSameDay:(NSCalendarDate *)date;


- (void)markForUnlockAfterSave;

- (void)editorDidFinishChanging:(id)editor;


- (void)editorWillStartChanging:(id)editor;

- (id)openAndLockInEditor;
- (NSMutableArray *)contacts;

@end

